<?php
/**
 * Plugin Name:       ProSlider WP
 * Plugin URI:        https://www.tdmedya.com
 * Description:       Swiper.js tabanlı, gelişmiş ve ultra esnek WordPress slider eklentisi.
 * Version:           2.1.0 (Final)
 * Author:            TD Medya & Gemini
 * Author URI:        https://www.tdmedya.com
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       pro-slider-wp
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Gerekli Dosyaları Dahil Et
if ( is_admin() ) {
    require_once plugin_dir_path( __FILE__ ) . 'admin/admin-page.php';
    require_once plugin_dir_path( __FILE__ ) . 'admin/settings-api.php';
}
require_once plugin_dir_path( __FILE__ ) . 'frontend/display-slider.php';
require_once plugin_dir_path( __FILE__ ) . 'frontend/shortcode.php';
require_once plugin_dir_path( __FILE__ ) . 'frontend/class-pro-slider-widget.php';

// Ön Yüz (Frontend) CSS ve JS Dosyalarını Yükleme
function pro_slider_wp_enqueue_assets() {
    wp_enqueue_style( 'swiper-css', plugin_dir_url( __FILE__ ) . 'assets/css/swiper-bundle.min.css', array(), '11.0.5' );
    wp_enqueue_style( 'pro-slider-wp-css', plugin_dir_url( __FILE__ ) . 'assets/css/pro-slider-style.css', array( 'swiper-css' ), '2.1.0' );
    
    $options = get_option('pro_slider_settings');
    
    $skin = isset($options['skin']) ? $options['skin'] : 'default';
    if ( $skin !== 'default' && strpos($skin, 'magazine-grid') === false ) {
        $skin_file_path = plugin_dir_path( __FILE__ ) . 'assets/css/skins/' . $skin . '.css';
        if ( file_exists($skin_file_path) ) {
            wp_enqueue_style(
                'pro-slider-skin-' . $skin,
                plugin_dir_url( __FILE__ ) . 'assets/css/skins/' . $skin . '.css',
                array( 'pro-slider-wp-css' ),
                '2.1.0'
            );
        }
    }

    $slider_settings_for_js = array(
        'autoplay'        => isset($options['autoplay']) && $options['autoplay'] === 'on',
        'delay'           => isset($options['delay']) ? intval($options['delay']) : 5000,
        'effect'          => isset($options['effect']) ? esc_attr($options['effect']) : 'slide',
        'show_arrows'     => isset($options['show_arrows']) ? ($options['show_arrows'] === 'on') : true,
        'show_pagination' => isset($options['show_pagination']) ? ($options['show_pagination'] === 'on') : true,
        'show_thumbnails' => isset($options['show_thumbnails']) && $options['show_thumbnails'] === 'on',
        'thumbnail_count' => isset($options['thumbnail_count']) ? intval($options['thumbnail_count']) : 6,
    );
    
    wp_enqueue_script( 'swiper-js', plugin_dir_url( __FILE__ ) . 'assets/js/swiper-bundle.min.js', array(), '11.0.5', true );
    wp_enqueue_script( 'pro-slider-wp-js', plugin_dir_url( __FILE__ ) . 'assets/js/pro-slider-frontend.js', array( 'jquery', 'swiper-js' ), '2.1.0', true );
    wp_localize_script( 'pro-slider-wp-js', 'proSliderSettings', $slider_settings_for_js );
}
add_action( 'wp_enqueue_scripts', 'pro_slider_wp_enqueue_assets' );

// Yönetim Paneli (Admin) CSS ve JS Dosyalarını Yükleme
function pro_slider_load_admin_assets( $hook ) {
    if ( 'toplevel_page_pro_slider_wp' != $hook ) {
        return;
    }
    wp_enqueue_style( 'select2-css', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css', array(), '4.1.0-rc.0' );
    wp_enqueue_script( 'select2-js', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js', array( 'jquery' ), '4.1.0-rc.0', true );
}
add_action( 'admin_enqueue_scripts', 'pro_slider_load_admin_assets' );